//
//  MCPAttribute.h
//  MCPersistence
//
//  Created by aj on Fri Dec 21 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCPDefinitionObject.h"
#import "MCPDefines.h"

@class MCPEntity;

@interface MCPAttribute : MCPDefinitionObject {

	MCPEntity		*_entity;
	
	int				_width;
	BOOL			_allowNull;
	BOOL			_isExternalBinary;
	BOOL			_isExternalObject;
	BOOL			_isPrimaryKey;
	BOOL            _isIndexed;
	
	id              _defaultValue;
	
	Class			_valueClass;

    MCPSupportedPlatforms   _supportedPlatforms; // All, Desktop only, Touch only
    NSString*               _supportedProduct;
}

- (void)setEntity:(MCPEntity *)entity;
- (MCPEntity *)entity;


- (NSString *)name;
- (NSString *)columnName;
- (NSString *)externalType;

- (void)setIsPrimaryKey:(BOOL)flag;
- (BOOL)isPrimaryKey;

- (BOOL)allowsNullValue;
- (void)setAllowsNullValue: (BOOL)flag;

- (void)setIsIndexed: (BOOL)flag;
- (BOOL)isIndexed;

- (id)defaultValue;
- (void)setDefaultValue: (id)aValue;

- (BOOL)isBinaryExternalType;
- (BOOL)isObjectExternalType;

- (NSString *)valueClassName;
- (Class)valueClass;
- (NSString *)valueType;
- (NSString *)valueWidth;
- (int)width;

- (MCPSupportedPlatforms)supportedPlatforms;
- (void)setSupportedPlatforms:(MCPSupportedPlatforms)aVal;

- (NSString*)supportedProduct;
- (void)setSupportedProduct: (NSString*)aProduct;

- (void) setName:(NSString *)name;
- (void) setColumnName:(NSString *)column;
- (void) setExternalType:(NSString *)type;
- (void) setValueClassName:(NSString *)classname;
- (void) setValueWidth:(NSString *) width;
- (void) setValueType:(NSString *)value;





@end
